/*
 * $Id: fixup_str2int.h 825 2007-02-16 13:04:16Z bastian $
 *
 * Benchmarking module for OpenSER
 *
 * Copyright (C) 2007 Collax GmbH
 *                    (Bastian Friedrich <bastian.friedrich@collax.com>)
 *
 * This file is part of openser, a free SIP server.
 *
 * openser is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version
 *
 * openser is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef FIXUP_STR2INT_H
#define FIXUP_STR2INT_H

#include "../../mem/mem.h"
#include "../../ut.h"

static int fixup_str2int(void** param, int param_no)
{
	unsigned long code;
	int err;

	if (param_no==1){
		code=str2s(*param, strlen(*param), &err);
		if (err==0){
			pkg_free(*param);
			*param=(void*)code;
			return 0;
		} else {
			LOG(L_ERR, "ERROR:benchmark:fixup_str2int: bad  number <%s>\n",
				(char*)(*param));
			return E_UNSPEC;
		}
	}

	return 0;
}

#endif /* FIXUP_STR2INT_H */

