
use OpenSER qw (log);
use OpenSER::Message;
use OpenSER::Constants;
use OpenSER::VDB::Adapter::Alias;

use Data::Dumper;

use lib "/home/bastian/s/modules/b_perlvdb/doc/samples/";
use simplealias;

my @d_aliases = (
	{
		alias_username => "viech",
		alias_domain => "bilbobox.coreworks.de",
		username => "bilbo",
		domain => "bilbobox.coreworks.de"
	},
	{
		alias_username => "hirsch",
		alias_domain => "bilbobox.coreworks.de",
		username => "bilbo",
		domain => "bilbobox.coreworks.de"
	},
	{
		alias_username => "schnipp",
		alias_domain => "172.16.1.200:5060",
		username => "foo",
		domain => "bilbobox.coreworks.de"
	},
);

sub perlsimplealias {
	my $msg = shift;

	my $ruri = $msg->getRURI();
	my $alias_username;
	my $alias_domain;
	if ($ruri =~ m/^sip:(.*)\@([^;]*)(.*)/) {
		$alias_username = $1;
		$alias_domain = $2;
	}

#	OpenSER::log(L_INFO, "trying direct simple alias - ruri='$ruri', u='$alias_username', d='$alias_domain'\n");

	foreach my $entry (@d_aliases) {
#		OpenSER::log(L_INFO, "checking $alias_username as ".$entry->{"alias_username"}." and $alias_domain as ".$entry->{alias_domain}."\n");
		
		if (($entry->{alias_username} eq $alias_username) && ($entry->{alias_domain} == $alias_domain)) {
			my $newruri = "sip:".$entry->{username}."\@".$entry->{domain};
			$msg->rewrite_ruri($newruri);
#			OpenSER::log(L_INFO, "found ruri $newruri\n");
			return 1;
		}
	}
	return -1;
}

1;
