/*****************************************************************************
 $Id: ImageFilter.java,v 1.7 2002/04/08 12:09:44 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI.ImageChooser;

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;

/**
 * The ImageFilter checks whether a file is to be displayed in the file
 * chooser. This info is derived from file's extension.
 * <p>This class was mostly stolen from Sun's documentation:
 * <a href="http://java.sun.com/docs/books/tutorial/uiswing/components/filechooser.html">FileChooser
 * Demo</a> (whoops... does this hurt GPL?!)</p>
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.7 $
 */
public class ImageFilter extends FileFilter {

    /**
     *  Accept all directories and all gif, jpg, or png files.
     *  @return File's acceptance.
     */
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String extension = ImageChooserUtils.getExtension(f);
	if (extension != null) {
            if (extension.equals(ImageChooserUtils.gif) ||
                extension.equals(ImageChooserUtils.jpeg)||
                extension.equals(ImageChooserUtils.jpg) ||
                extension.equals(ImageChooserUtils.png)) {
                    return true;
            } else {
                return false;
            }
    	}

        return false;
    }

    /**
     *  The description of this filter
     *  @return The literal string "Images (png, gif, jpg)".
     */
    public String getDescription() {
        return "Images (png, gif, jpg)";
    }
}
