/*****************************************************************************
 $Id: TRexFilterRGB.java,v 1.11 2002/04/13 17:42:10 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.Filter;

import java.awt.image.RGBImageFilter;
import trex.*;

/**
 * This is the base class for all encrypt and decrypt filters.
 * Filters have to implement the filterRGB() function as defined
 * in RGBImageFilter.
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.11 $
 */
public abstract class TRexFilterRGB extends RGBImageFilter {

  /**
   * Data to hide as a byte array. Is converted to a <code>String</code>
   * by getData().
   * @see #getData
   */
  protected byte[] data;

  /**
   * Objective picture's size.
   * This is needed for calculating the pixel's absoulte position in the
   * one-dimensional array.
   */
  protected int w, h;

  /**
   * Return contained data as a <code>String</code>.
   * @return Contained data.
   */
  public String getData() throws DecryptImpossibleException {
    if (data == null) return null;
    int datalen = TRexUtil.bytesToInt(TRexUtil.subArray(data, 0, 4));

    if ((datalen < 0) || (datalen > data.length-4))
      throw new DecryptImpossibleException();

    return new String(TRexUtil.subArray(data, 4, datalen));
  }

  /**
   * Default constructor.
   * Initializes data fields with null values. Should never be used.
   */
  public TRexFilterRGB() {
    // This seems superfluous
    super();
    data = null;
    w = h = 0;
  }

  /**
   * Creates a new filter.
   * @param data Data to hide
   * @param w Picture's width
   * @param h Picture's height
   */
  public TRexFilterRGB(String data, int w, int h) {
    this();
    if (data != null)
      this.data = TRexUtil.concatByteArrays(
                                  TRexUtil.intToBytes(data.length()),
                                  data.getBytes());
    this.w = w;
    this.h = h;
  }

}