/*****************************************************************************
 $Id: JMessageBox.java,v 1.10 2002/04/26 22:43:32 bastian Exp $
 Part of TRex, (c) 2001, 2002 Bastian Friedrich <bastian@bastian-friedrich.de>
 This software licensed under the GPL.
 *****************************************************************************/
package trex.GUI;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

/**
 * Provides a simple MessageBox class. Title, text and button types can be set.
 * The selected button type is returned.
 * As the auther found out about JOptionPane, this class is no longer used in
 * TRex.
 * @author Bastian Friedrich <a href="mailto:bastian@bastian-friedrich.de">&lt;bastian@bastian-friedrich.de&gt;</a>
 * @version $Revision: 1.10 $
 */

public class JMessageBox extends JDialog implements WindowListener, ActionListener {

  /**
   * Box' layout.
   */
  GridLayout gridLayout1 = new GridLayout();
  /**
   * Upper panel to contain label.
   */
  JPanel jPanel1 = new JPanel();
  /**
   * Lower panel to contain button(s).
   */
  JPanel jPanel2 = new JPanel();
  /**
   * Label to contain text.
   */
  JLabel jLabel = new JLabel();

  /**
   * Button type: OK
   */
  public final static int OK = 1;
  /**
   * Button type: Cancel
   */
  public final static int CANCEL = 2;
  /**
   * Button type: Yes
   */
  public final static int YES = 4;
  /**
   * Button type: No
   */
  public final static int NO = 8;
  /**
   * Button type: Abort
   */
  public final static int ABORT = 16;
  /**
   * Button type: Ignore
   */
  public final static int IGNORE = 32;

  /**
   * Button objects for all button types.
   */
  JButton ok,
          cancel,
          yes,
          no,
          abort,
          ignore;

  /**
   * Text to display.
   */
  String text;
  /**
   * Window title.
   */
  String title;

  /**
   * Buttons to display as bitmask.
   */
  int button_type;

  /**
   * Result to pass back.
   */
  int result;

  /**
   * Display a modal message box and return selected button.
   * As a static method, you don't need to instantiate this class. Call this e.g. as:
   * <code>
   * JMessageBox.Box(this, "Hello!", "Hello World! Continue?", JMessageBox.YES | JMessageBox.NO);
   * </code>
   * @param parent Parent window. May be any AWT Frame.
   * @param title Window title.
   * @param text Displayed text.
   * @param button_type Buttons to be displayed. Values are "OR"s of the class' constants.
   * @return Clicked button (See "constant fields")
   */
  public static int Box(Frame parent, String title, String text, int button_type) {
    // swing doesn't like parent being null?!
    if (parent == null)
      return ABORT;
    // create a new JMessageBox
    JMessageBox w = new JMessageBox(parent, title, text, button_type);

    Dimension dlgSize = w.getPreferredSize();
    dlgSize.setSize(dlgSize.getWidth(),
                    (int)(dlgSize.getHeight()*1.3));
    Dimension frmSize = parent.getSize();
    Point loc = parent.getLocation();
    // Centered position for dialog window
    w.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    w.setSize(dlgSize);
    // display the created MessageBox (modal dialog).
    w.show();
    // return pressed button
    return w.result;
  }

  /**
   * Private constructor.
   * Set param data for this instance and initialize window.
   */
  private JMessageBox(Frame parent, String title, String text, int button_type) {
    this.title = title; this.text = text; this.button_type = button_type;

    enableEvents(AWTEvent.WINDOW_EVENT_MASK);

    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * Initialize window.
   * Built by JBuilder, don't change too much :)
   */
  private void jbInit() throws Exception {
    this.getContentPane().setLayout(gridLayout1);
    this.setTitle(title);
    jLabel.setText(this.text);
    gridLayout1.setRows(2);
    this.setModal(true);
    this.getContentPane().add(jPanel1, null);
    jPanel1.add(jLabel, null);
    this.getContentPane().add(jPanel2, null);

    // Check button types and insert them accordingly
    if ((button_type & this.OK) > 0) {
      ok = new JButton("OK");
      ok.addActionListener(this);
      jPanel2.add(ok, null);
    }

    if ((button_type & this.CANCEL) > 0) {
      cancel = new JButton("Cancel");
      cancel.addActionListener(this);
      jPanel2.add(cancel, null);
    }

    if ((button_type & this.YES) > 0) {
      yes = new JButton("Yes");
      yes.addActionListener(this);
      jPanel2.add(yes, null);
    }

    if ((button_type & this.NO) > 0) {
      no = new JButton("No");
      no.addActionListener(this);
      jPanel2.add(no, null);
    }

    if ((button_type & this.ABORT) > 0) {
      abort = new JButton("Abort");
      abort.addActionListener(this);
      jPanel2.add(abort, null);
    }

    if ((button_type & this.IGNORE) > 0) {
      ignore = new JButton("Ignore");
      ignore.addActionListener(this);
      jPanel2.add(ignore, null);
    }

  }

  /**Close the dialog on a button event*/
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == ok) {
      this.result = this.OK; dispose();
    }

    if (e.getSource() == cancel) {
      this.result = this.CANCEL; dispose();
    }

    if (e.getSource() == yes) {
      this.result = this.YES; dispose();
    }

    if (e.getSource() == no) {
      this.result = this.NO; dispose();
    }

    if (e.getSource() == abort) {
      this.result = this.ABORT; dispose();
    }

    if (e.getSource() == ignore) {
      this.result = this.IGNORE; dispose();
    }
  }

  /**
   * Window closing is understood as "Abort" button.
   */
  public void windowClosing (WindowEvent e) {
    result = this.ABORT;
    dispose();
  }

  // Interface needs these methods. Unused.
  /**
   * Event handling. Unused.
   */
  public void windowClosed (WindowEvent e) {}
  /**
   * Event handling. Unused.
   */
  public void windowOpened (WindowEvent e) {}
  /**
   * Event handling. Unused.
   */
  public void windowIconified (WindowEvent e) {}
  /**
   * Event handling. Unused.
   */
  public void windowDeiconified (WindowEvent e) {}
  /**
   * Event handling. Unused.
   */
  public void windowActivated (WindowEvent e) {}
  /**
   * Event handling. Unused.
   */
  public void windowDeactivated (WindowEvent e) {}

}